/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs;

import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.fcs.FcsException;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.IncomingStreamEvent;
import com.ibm.hwmca.fw.fcs.IncomingStreamEventListener;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.impl.FcsConnectionManager;
import com.ibm.hwmca.fw.fcs.impl.FcsInternalConstants;
import com.ibm.hwmca.fw.fcs.impl.stream.StreamSender;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FcsConnection
implements FcsInternalConstants {
    private Connection connection;
    private MachineId machineId;
    private FcsServiceId serviceId;
    private int otherId;
    private int id;
    private static Object counterLock = new Object();
    private static int counter = 1;
    private Map receivedDataMap;
    private List listeners;
    private static final String TRACE_MASKD = "XFCSCOND";
    private static final String TRACE_MASKF = "XFCSCONF";
    private static final String TRACE_MASKT = "XFCSCONT";

    public Socket getSocket() {
        return this.connection.getSocket();
    }

    public MachineId getMachineId() {
        return this.machineId;
    }

    public FcsServiceId getServiceId() {
        return this.serviceId;
    }

    public void addIncomingStreamListener(IncomingStreamEventListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        this.listeners.add(listener);
    }

    public void removeIncomingStreamListener(IncomingStreamEventListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        this.listeners.remove(listener);
    }

    public void fireIncomingStreamEvent(IncomingStreamEvent event) {
        InputStream in = event.getStream();
        if (in != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IncomingStreamEventListener listener = (IncomingStreamEventListener)iterator.next();
                new FcsEventThread(listener, event).start();
            }
        }
    }

    public void sendStream(String streamTitle, InputStream in) {
        Trace.trace(TRACE_MASKT, "-> sendStream()");
        StreamSender streamSender = new StreamSender(this.machineId, streamTitle, in, this.otherId);
        Thread t = new Thread((Runnable)streamSender, "FCS - StreamSender( " + this.id + "," + this.otherId + " )");
        t.start();
        Trace.trace(TRACE_MASKT, "<- sendStream()");
    }

    public void sendFile(File file) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> sendFile()");
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Illegal file passed in to sendFile");
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            this.sendStream(file.getName(), fis);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKT, "<- sendFile");
    }

    public static FcsConnection connect(MachineId machineId, FcsServiceId serviceId) throws IllegalArgumentException, FcsException {
        int[] order = new int[machineId.getNicAddresses().length];
        int i = 0;
        while (i < order.length) {
            order[i] = i;
            ++i;
        }
        return FcsConnection.connect(machineId, serviceId, order);
    }

    public static FcsConnection connect(MachineId machineId, FcsServiceId serviceId, int[] connectionOrder) throws IllegalArgumentException, FcsException {
        if (machineId == null) {
            throw new IllegalArgumentException("MachineId passed to FcsConnection can not be null");
        }
        if (serviceId == null) {
            throw new IllegalArgumentException("ServiceId passed to FcsConnection can not be null");
        }
        if (connectionOrder.length > machineId.getNicAddresses().length) {
            throw new IllegalArgumentException("Illegal number of NICs specified in connection order on FcsConnection.connect()");
        }
        int i = 0;
        while (i < connectionOrder.length) {
            if (connectionOrder[i] > machineId.getNicAddresses().length) {
                throw new IllegalArgumentException("Illegal NIC specified: " + connectionOrder[i] + " on FcsConnection.connect()");
            }
            ++i;
        }
        FcsConnection c = new FcsConnection(machineId, serviceId);
        c.connectSocket(connectionOrder);
        FcsConnectionManager.addConnection(c);
        return c;
    }

    public static FcsConnection associate(Map map, Connection connection) throws IllegalArgumentException, FcsException {
        if (connection == null) {
            throw new IllegalArgumentException("Connection passed to associate() can not be null");
        }
        MachineId machineId = null;
        FcsServiceId serviceId = null;
        int otherId = 0;
        if (map != null) {
            machineId = (MachineId)map.get("machineId");
            serviceId = (FcsServiceId)map.get("serviceId");
            Object otherIdObject = map.get("connectionId");
            if (otherIdObject != null && otherIdObject instanceof Integer) {
                otherId = (Integer)map.get("connectionId");
            }
        }
        FcsConnection c = new FcsConnection(machineId, serviceId, otherId, connection);
        c.receivedDataMap = map;
        try {
            ObjectOutputStream oos = new ObjectOutputStream(connection.getSocket().getOutputStream());
            oos.flush();
            oos.writeObject(c.getConnectionParm());
            oos.flush();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "exception in associate(" + c.id + "):" + e.getMessage());
        }
        FcsConnectionManager.addConnection(c);
        return c;
    }

    /*
     * Unable to fully structure code
     */
    private void connectSocket(int[] connectionOrder) throws FcsException {
        localMachine = FcsServer.getFcsServer().getLocalMachineId();
        isLocalConnect = this.machineId.equals(localMachine) != false;
        done = false;
        i = 0;
        if (!FcsServer.getFcsServer().isBlackListed(this.machineId)) ** GOTO lbl15
        Trace.trace("XFCSCONF", "Machine is blacklisted. We will not connect to it: " + this.machineId);
        throw new FcsException("Unable to connect.");
lbl-1000:
        // 1 sources

        {
            iaddr = this.machineId.getNicAddresses()[connectionOrder[i]];
            if ((isLocalConnect || !isLocalConnect && !iaddr.getHostAddress().startsWith("127.")) && !iaddr.getHostAddress().equals("0.0.0.0")) {
                this.connection = FcsConnectionManager.connect(iaddr, this.getConnectionParm());
            }
            if (this.connection != null) {
                done = true;
                continue;
            }
            ++i;
lbl15:
            // 3 sources

            ** while (!done && i < connectionOrder.length)
        }
lbl16:
        // 1 sources

        if (this.connection == null) {
            Trace.trace("XFCSCONF", "Unable to connect, removing this machine from the list of valid machines (" + this.machineId + ")");
            thread = new Thread("FCS failure connection notification thread"){

                public void run() {
                    FcsServer.getFcsServer().removeRemoteServiceList(FcsConnection.this.machineId);
                }
            };
            thread.start();
            throw new FcsException("Unable to connect.");
        }
        try {
            ois = new ObjectInputStream(this.connection.getSocket().getInputStream());
            oldTimeout = this.connection.getSocket().getSoTimeout();
            this.connection.getSocket().setSoTimeout(120000);
            this.receivedDataMap = (Map)ois.readObject();
            this.connection.getSocket().setSoTimeout(oldTimeout);
            Trace.trace("XFCSCOND", "New FCS connection established.  My ID: " + this.id + ", their ID: " + this.receivedDataMap.get("connectionId"));
        }
        catch (Exception e) {
            Trace.trace("XFCSCONF", "Exception in connect (" + this.id + "): " + e.getMessage());
            this.connection.close();
            throw new FcsException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FcsConnection(MachineId machineId, FcsServiceId serviceId) {
        this.machineId = machineId;
        this.serviceId = serviceId;
        Object object = counterLock;
        synchronized (object) {
            this.id = counter++;
        }
        this.listeners = new ArrayList();
    }

    private FcsConnection(MachineId machineId, FcsServiceId serviceId, int otherId, Connection connection) {
        this(machineId, serviceId);
        this.otherId = otherId;
        this.connection = connection;
    }

    public int getConnectionId() {
        return this.id;
    }

    private Serializable getConnectionParm() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("connectionId", new Integer(this.id));
        map.put("machineId", FcsServer.getFcsServer().getLocalMachineId());
        map.put("serviceId", this.serviceId);
        return map;
    }

    class FcsEventThread
    extends Thread {
        private IncomingStreamEventListener listener;
        private IncomingStreamEvent event;

        FcsEventThread(IncomingStreamEventListener listener, IncomingStreamEvent event) {
            super("FCS - Event Thread ( " + FcsConnection.this.id + ", " + FcsConnection.this.otherId + " )");
            this.listener = listener;
            this.event = event;
        }

        public void run() {
            this.listener.streamConnected(this.event);
        }
    }
}

